// Persistence of Vision Ray Tracer Include File
// File: beads.inc
// Vers: 3.6
// Desc: Include file for the Beads'N'Wires project
// Date: Sept-Oct 2004
// Auth: Maurice Hendrix


#include "shapes.inc"
#include "bead_properties.inc"


#declare bore_hole=
cylinder{
	y * (bead_size+.1),
	-y * (bead_size+.1),
	bead_bore
}

#declare bal = 
difference{
	sphere {
  	<0,0,0>, bead_size
	}
	object{ bore_hole }
	box{
		<bead_size, bead_size - bal_cap, bead_size>
		<-bead_size, bead_size + bal_cap, -bead_size>
	}
	box{
		<bead_size, -bead_size - bal_cap, bead_size>
		<-bead_size, -bead_size + bal_cap, -bead_size>
	}
	translate y*bead_size
}

#declare ovaal = 
difference{
	sphere {
  	<0,0,0>, bead_size
	}
	object{bore_hole}
	box{
		<bead_size, bead_size - ovaal_cap, bead_size>
		<-bead_size, bead_size + ovaal_cap, -bead_size>
	}
	box{
		<bead_size, -bead_size - ovaal_cap, bead_size>
		<-bead_size, -bead_size + ovaal_cap, -bead_size>
	}
	
	scale <1,ovaal_scale,1>
	translate y*bead_size
}

#declare he=ribbe/2;

#declare kubus = 
difference{
	// Round_Box(A, B, WireRadius, UseMerge)
  Round_Box(<-he,-he,-he>,<he,he,he>, 0.15*he   , 1)
  object{bore_hole}
  translate y*he
}

#declare cyl =
difference{	
	// Round_Cylinder(A, B, Radius, EdgeRadius, UseMerge)
	Round_Cylinder(<0,-he,0>,<0,he,0>, bead_size, 0.15*he, 1)
	object{bore_hole}
	translate y*he
}


//
